﻿#pragma once

#include  "Main.hpp"
#include  <szArchiveFileExtractClientCallback.hpp>
#include  <buffers.hpp>
#include  <strsafe.h>

class COverwriteDialog :
  public CDialogImpl<COverwriteDialog>,
  public CWinDataExchange<COverwriteDialog>
{
private:
  CComBSTR overwriteCaption;
  CComBSTR overwritePath;
  CComBSTR eTime;
  CComBSTR eSize;
  CComBSTR nTime;
  CComBSTR nSize;
  u32      *answer;
  HICON    hIcon;
  bool     applyAll;

public:
  enum { IDD = IDD_OVERWRITE };

  COverwriteDialog(const szchar *overwriteCaption, const szstring &overwrittenPath, const szpp::Time &eTime, const u64 &eSize, const szpp::Time &nTime, const u64 &nSize, u32 *answer) :
    overwriteCaption(overwriteCaption),
    overwritePath(overwrittenPath.c_str()),
    eTime(), eSize(), nTime(), nSize(),
    answer(answer), hIcon(0), applyAll(false)
  {
    SHFILEINFO fileinfo;
    ZeroMemory(&fileinfo, sizeof(fileinfo));

    if (SHGetFileInfo(overwrittenPath.c_str(), 0, &fileinfo, sizeof(fileinfo), SHGFI_ICON))
      hIcon = fileinfo.hIcon;


    sbuf<szchar, 256> buf1, buf2;

    StringCbPrintf(buf1, buf1.bytes(), SZL("%lu Bytes"), eSize);
    this->eSize = buf1;

    StringCbPrintf(buf1, buf1.bytes(), SZT("%lu Bytes"), nSize);
    this->nSize = buf1;

    if (eTime.get() != 0)
    {
      SYSTEMTIME sysTime;
      FileTimeToSystemTime(reinterpret_cast<const FILETIME *>(&eTime), &sysTime);
      GetDateFormat(LOCALE_USER_DEFAULT, DATE_LONGDATE, &sysTime, 0, buf1, buf1.size());
      GetTimeFormat(LOCALE_USER_DEFAULT, TIME_FORCE24HOURFORMAT, &sysTime, 0, buf2, buf2.size());
      StringCchCat(buf1, buf1.size(), buf2);
      this->eTime = buf1;
    }

    if (nTime.get() != 0)
    {
      SYSTEMTIME sysTime;
      FileTimeToSystemTime(reinterpret_cast<const FILETIME *>(&nTime), &sysTime);
      GetDateFormat(LOCALE_USER_DEFAULT, DATE_LONGDATE, &sysTime, 0, buf1, buf1.size());
      GetTimeFormat(LOCALE_USER_DEFAULT, TIME_FORCE24HOURFORMAT, &sysTime, 0, buf2, buf2.size());
      StringCchCat(buf1, buf1.size(), buf2);
      this->nTime = buf1;
    }
  }

  BEGIN_MSG_MAP(COverwriteDialog)
    MESSAGE_HANDLER(WM_INITDIALOG, OnInitDialog)
    MSG_WM_PAINT(OnPaint)
    COMMAND_ID_HANDLER(IDOK, OnYes)
    COMMAND_ID_HANDLER(IDC_NO_BUTTON, OnNo)
    COMMAND_ID_HANDLER(IDC_AUTO_RENAME_BUTTON, OnAutoRename)
    COMMAND_ID_HANDLER(IDCANCEL, OnCancel)
  END_MSG_MAP()

  BEGIN_DDX_MAP(COverwriteDialog)
    DDX_TEXT (IDC_OVERWRITE_CAPTION,  overwriteCaption)
    DDX_TEXT (IDC_OVERWRITE_PATH,     overwritePath)
    DDX_TEXT (IDC_EXISTING_SIZE_TEXT, eSize)
    DDX_TEXT (IDC_EXISTING_DATE_TEXT, eTime)
    DDX_TEXT (IDC_NEW_SIZE_TEXT,      nSize)
    DDX_TEXT (IDC_NEW_DATE_TEXT,      nTime)
    DDX_CHECK(IDC_APPLY_ALL_CHECK,    applyAll)
  END_DDX_MAP()

  LRESULT OnInitDialog(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL &bHandled)
  {
    CenterWindow();

    HICON hIcon = (HICON)::LoadImage(theModule.GetResourceInstance(), MAKEINTRESOURCE(IDR_MAINFRAME), 
      IMAGE_ICON, ::GetSystemMetrics(SM_CXICON), ::GetSystemMetrics(SM_CYICON), LR_DEFAULTCOLOR);
    SetIcon(hIcon, TRUE);
    HICON hIconSmall = (HICON)::LoadImage(theModule.GetResourceInstance(), MAKEINTRESOURCE(IDR_MAINFRAME), 
      IMAGE_ICON, ::GetSystemMetrics(SM_CXSMICON), ::GetSystemMetrics(SM_CYSMICON), LR_DEFAULTCOLOR);
    SetIcon(hIconSmall, FALSE);

    DoDataExchange(FALSE);

    SetWindowText(SZT("Confirm overwrite"));
    SetDlgItemText(IDC_EXISTING_GROUP, SZT("Existing file"));
    SetDlgItemText(IDC_EXISTING_SIZE_CAPTION, SZT("Size:"));
    SetDlgItemText(IDC_EXISTING_DATE_CAPTION, SZT("Date time:"));
    SetDlgItemText(IDC_NEW_GROUP, SZT("New file"));
    SetDlgItemText(IDC_NEW_SIZE_CAPTION, SZT("Size:"));
    SetDlgItemText(IDC_NEW_DATE_CAPTION, SZT("Date time:"));

    SetDlgItemText(IDOK, SZT("Yes"));
    SetDlgItemText(IDC_NO_BUTTON, SZT("No"));
    SetDlgItemText(IDC_AUTO_RENAME_BUTTON, SZT("Auto rename"));
    SetDlgItemText(IDCANCEL, SZT("Cancel"));
    SetDlgItemText(IDC_APPLY_ALL_CHECK, SZT("Apply to all"));

    return TRUE;
  }

  void OnPaint(CDCHandle dc)
  {
    if (hIcon != 0)
    {
      RECT  rc;
      POINT pt;
      ::GetWindowRect(GetDlgItem(IDC_ICON_FRAME), &rc);
      pt.x = rc.left;
      pt.y = rc.top;
      ScreenToClient(&pt);
      
      CPaintDC cdc(m_hWnd);
      cdc.DrawIcon(pt.x, pt.y, hIcon);
    }
  }

  LRESULT OnYes(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL &bHandled)
  {
    DoDataExchange(TRUE);

    *answer = applyAll ? szpp::ArchiveFileExtractClientCallback::YesToAll : szpp::ArchiveFileExtractClientCallback::Yes;

    EndDialog(wID);
    return 0;
  }

  LRESULT OnNo(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL &bHandled)
  {
    DoDataExchange(TRUE);

    *answer = applyAll ? szpp::ArchiveFileExtractClientCallback::NoToAll : szpp::ArchiveFileExtractClientCallback::No;

    EndDialog(wID);
    return 0;
  }

  LRESULT OnAutoRename(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL &bHandled)
  {
    DoDataExchange(TRUE);

    *answer = szpp::ArchiveFileExtractClientCallback::AutoRename;

    EndDialog(wID);
    return 0;
  }

  LRESULT OnCancel(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL &bHandled)
  {
    *answer = szpp::ArchiveFileExtractClientCallback::Cancel;
    EndDialog(wID);
    return 0;
  }
};
